using System;
using System.Collections.Generic;

class Program
{
    static int n, q;
    static int[] a;
    
    static void Main()
    {
        var line1 = Console.ReadLine().Split();
        n = int.Parse(line1[0]);
        q = int.Parse(line1[1]);
        
        a = new int[n + 1];
        var aLine = Console.ReadLine().Split();
        for (int i = 1; i <= n; i++)
            a[i] = int.Parse(aLine[i - 1]);
        
        for (int i = 0; i < q; i++)
        {
            var query = Console.ReadLine().Split();
            int t = int.Parse(query[0]);
            
            if (t == 1)
            {
                int k = int.Parse(query[1]);
                Console.WriteLine(Solve(k));
            }
            else
            {
                int x = int.Parse(query[1]);
                int y = int.Parse(query[2]);
                a[x] = y;
            }
        }
    }
    
    static long Solve(int k)
    {
        // Izracunaj last[v] i count[v] za sve vrednosti
        int[] last = new int[n + 1];
        int[] totalCount = new int[n + 1];
        long totalSum = 0;
        
        for (int i = 1; i <= n; i++)
        {
            last[a[i]] = i;
            totalCount[a[i]]++;
            totalSum += a[i];
        }
        
        if (k >= n)
        {
            return totalSum;
        }
        
        // Grupiši vrednosti po last[v]
        // eventsAtPos[pos] = lista vrednosti koje postaju kompletne na poziciji pos
        List<int>[] eventsAtPos = new List<int>[n + 1];
        for (int i = 0; i <= n; i++)
            eventsAtPos[i] = new List<int>();
        
        bool[] seen = new bool[n + 1];
        for (int i = 1; i <= n; i++)
        {
            int v = a[i];
            if (!seen[v])
            {
                seen[v] = true;
                eventsAtPos[last[v]].Add(v);
            }
        }
        
        // Max-heap: (sum, value)
        // C# nema ugraden max-heap, koristimo SortedSet sa custom comparer
        // ili jednostavno negiramo vrednosti u min-heap
        var heap = new PriorityQueue<int, long>(Comparer<long>.Create((a, b) => b.CompareTo(a)));
        
        // Dodaj vrednosti koje su kompletne od pocetka (last[v] <= k)
        for (int pos = 1; pos <= k; pos++)
        {
            foreach (int v in eventsAtPos[pos])
            {
                long sum = (long)totalCount[v] * v;
                heap.Enqueue(v, sum);
            }
        }
        
        bool[] played = new bool[n + 1];
        long playedSum = 0;
        
        // Simulacija: za svaku poziciju od k+1 do n
        for (int pos = k + 1; pos <= n; pos++)
        {
            // Dodaj vrednosti koje postaju kompletne na ovoj poziciji
            foreach (int v in eventsAtPos[pos])
            {
                long sum = (long)totalCount[v] * v;
                heap.Enqueue(v, sum);
            }
            
            // Odigraj vrednost sa najvecom sumom (lazy deletion)
            while (heap.Count > 0)
            {
                if (heap.TryPeek(out int topValue, out long topSum))
                {
                    if (played[topValue])
                    {
                        heap.Dequeue();
                        continue;
                    }
                    // Ova vrednost nije odigrana, odigraj je
                    heap.Dequeue();
                    played[topValue] = true;
                    playedSum += topSum;
                    break;
                }
            }
            
            // Ako je heap prazan, odigramo jednu kartu (najvecu u ruci)
            // U praksi, ovo se dešava retko ako pravilno pratimo
            // Ali za korektnost, trebalo bi dodati fallback
        }
        
        return totalSum - playedSum;
    }
}